# Script de Configuração do Registro do Windows para Plugin Flluir
# Este script configura o PlayerDebugMode e AllowUnsignedExtensions para o CEP
# Execute como Administrador

Write-Host "========================================" -ForegroundColor Cyan
Write-Host "  Configuração do Registro - Plugin Flluir" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Verificar se está executando como administrador
$isAdmin = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)

if (-not $isAdmin) {
    Write-Host "⚠️  ATENÇÃO: Este script precisa ser executado como Administrador!" -ForegroundColor Yellow
    Write-Host ""
    Write-Host "Para executar como Administrador:" -ForegroundColor Yellow
    Write-Host "1. Clique com botão direito no PowerShell" -ForegroundColor Yellow
    Write-Host "2. Selecione 'Executar como administrador'" -ForegroundColor Yellow
    Write-Host "3. Execute este script novamente" -ForegroundColor Yellow
    Write-Host ""
    Read-Host "Pressione Enter para sair"
    exit 1
}

Write-Host "✅ Executando como Administrador" -ForegroundColor Green
Write-Host ""

# Versões do CEP a configurar
$cepVersions = @("CSXS.12", "CSXS.11", "CSXS.10", "CSXS.9")

Write-Host "Configurando PlayerDebugMode e AllowUnsignedExtensions..." -ForegroundColor Yellow
Write-Host ""

foreach ($version in $cepVersions) {
    $regPath = "HKCU:\Software\Adobe\$version"
    
    try {
        # Criar chave se não existir
        if (-not (Test-Path $regPath)) {
            New-Item -Path $regPath -Force | Out-Null
            Write-Host "  ✓ Criada chave: $regPath" -ForegroundColor Gray
        }
        
        # Configurar PlayerDebugMode
        Set-ItemProperty -Path $regPath -Name "PlayerDebugMode" -Value 1 -Type DWord -ErrorAction Stop
        Write-Host "  ✓ PlayerDebugMode configurado para $version" -ForegroundColor Green
        
        # Configurar AllowUnsignedExtensions
        Set-ItemProperty -Path $regPath -Name "AllowUnsignedExtensions" -Value 1 -Type DWord -ErrorAction Stop
        Write-Host "  ✓ AllowUnsignedExtensions configurado para $version" -ForegroundColor Green
        
    } catch {
        Write-Host "  ✗ Erro ao configurar $version : $_" -ForegroundColor Red
    }
}

Write-Host ""
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "✅ Configuração concluída com sucesso!" -ForegroundColor Green
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""
Write-Host "⚠️  PRÓXIMOS PASSOS:" -ForegroundColor Yellow
Write-Host "1. Feche COMPLETAMENTE o Premiere Pro (todas as janelas)" -ForegroundColor Yellow
Write-Host "2. Aguarde 5-10 segundos" -ForegroundColor Yellow
Write-Host "3. Abra o Premiere Pro novamente" -ForegroundColor Yellow
Write-Host "4. Vá em Janela → Extensões → Flluir: Sync" -ForegroundColor Yellow
Write-Host ""
Write-Host "O plugin deve funcionar normalmente agora!" -ForegroundColor Green
Write-Host ""

Read-Host "Pressione Enter para sair"
